:init
REM initialization of command variables
set "capture=0"
set "extcap_interfaces=0"
set "extcap_interface="
set "extcap_dlts=0"
set "fifo="

:parse
REM check and parse command variables
if "%~1" == "" goto :main
if /i "%~1" == "--capture" set "capture=1" & shift & goto:parse
if /i "%~1" == "--extcap-interfaces" set "extcap_interfaces=1" & shift & goto:parse
if /i "%~1" == "--extcap-interface" set "extcap_interface=%~2" & shift & shift & goto:parse
if /i "%~1" == "--fifo" set "fifo=%~2" & shift & shift & goto:parse
if /i "%~1" == "--extcap-dlts" set "extcap_dlts=1" & shift & goto:parse
shift
goto :parse

:main
REM check flags and process setting/capturing of extcap
if "%extcap_interfaces%"=="1" call :extcap_interface_func & goto :end
if "%extcap_dlts%"=="1" call :extcap_dlts_func & goto :end
if "%capture%"=="1" call :capture_func & goto :end
exit /B 1


:extcap_interface_func
REM show extcap interface info.
echo interface {value=test2}{display=Capture from Pi}
exit /B 0

:extcap_dlts_func
REM show DLT info.
echo dlt {number=147}{name=test2}{display=Layer2 DLT}
exit /B 0

:capture_func
REM create sshdump.exe command
"C:\Program Files\Wireshark\extcap\sshdump.exe" --capture --extcap-interface sshdump.exe --fifo %fifo% --remote-host 10.0.0.201 --remote-port 22 --remote-password raspberry --debug --remote-sudo --remote-capture-command "dumpcap -P -w -" --debug-file C:\Users\TakeshitaMegumi\Desktop\debug.txt --remote-username pi --remote-interface eth0 true 
exit /B


:end
REM finish processing 
exit /B